import pygame
#zaimportowanie pliku element
import Element


Szerokosc_Ekranu = 800
Wysokosc_Ekranu = 600

obraz_tla= pygame.image.load('images/background.png')
obraz_bazy_postaci = pygame.image.load('images/base.png')

pygame.init()

ekran = pygame.display.set_mode([Szerokosc_Ekranu, Wysokosc_Ekranu])
zegar = pygame.time.Clock()
#dodajemy obiekt czcionki   
pygame.font.init()
moja_czcionka = pygame.font.SysFont('Comic Sans MS', 30)

#Elementy stroju
nakrycia_glowy = Element.NakrycieGlowy()
ubranie_element = Element.UbranieElement()
oczy_element = Element.OczyElement()
bron_element = Element.BronElement()

def wypisz_tekst(ekran, tekst, pozycja):
    napis = moja_czcionka.render(tekst, False, (255, 255, 255))
    ekran.blit(napis, pozycja)

gra_dziala = True
zapisywanie = False
while gra_dziala:
    for zdarzenie in pygame.event.get():
        if zdarzenie.type == pygame.KEYDOWN:
            if zdarzenie.key == pygame.K_ESCAPE:
                gra_dziala = False
            if zdarzenie.key == pygame.K_q:
                nakrycia_glowy.wybierzNastepny()
            if zdarzenie.key == pygame.K_w:
                oczy_element.wybierzNastepny()
            if zdarzenie.key == pygame.K_e:
                ubranie_element.wybierzNastepny()
            if zdarzenie.key == pygame.K_r:
                bron_element.wybierzNastepny()
            if zdarzenie.key == pygame.K_s:
                zapisywanie = True
                
        elif zdarzenie.type == pygame.QUIT:
            gra_dziala = False 

    #rysowanie tła
    ekran.blit(obraz_tla, (0, 0))
    ekran.blit(obraz_bazy_postaci, (270, 130))
    #rysowanie elemntu postaci
    ekran.blit(ubranie_element.wybranyObraz(), (270, 130))
    ekran.blit(oczy_element.wybranyObraz(), (270, 130))
    ekran.blit(nakrycia_glowy.wybranyObraz(), (270, 130))
    ekran.blit(bron_element.wybranyObraz(), (270, 130))

    #zapisywanie
    if zapisywanie:
        pygame.image.save(ekran, 'postac.png')
        zapisywanie = False

    #wypisanie informacji o elemencie eq
    wypisz_tekst(ekran, f'[Q] Glowa: {nakrycia_glowy.wybrany}', (100,100))
    wypisz_tekst(ekran, f'[W] Oczy: {oczy_element.wybrany}', (100,140))
    wypisz_tekst(ekran, f'[E] Stroj: {ubranie_element.wybrany}', (100,180))
    wypisz_tekst(ekran, f'[R] Bron: {bron_element.wybrany}', (100,220))
    wypisz_tekst(ekran, f'[S] Zapisz:', (100,260))

    #czyszczenie ekranu
    pygame.display.flip()
    #Stałe fps na 30
    zegar.tick(30)
#Zamknięcie aplikacji
pygame.quit()